#include "pvmuser.h"
#include "pvm_consts.h"
#include "xab.h"

/*
 * XXX should frcvinfo() have some way to report the resulting length
 * of the proc string?
 */

void
FUNCTION(frcvinfo) ARGS(`len, type, STRING_ARG(proc), inum, cc')
int *len, *type, *inum, *cc;
STRING_ARG_DECL(proc);
{
	char tproc[MAX_PROC_NAME + 1];
	int x;

	*cc = rcvinfo(len, type, tproc, inum);

#if 0
	/* XXX should we report this error, or just silently truncate? */
	if ((x = strlen(tproc)) > STRING_LEN(proc)) {
		*cc = pvm_uerr("frcvinfo", PvmTooLong);
	}
#endif

	/*
	 * copy up to STRING_LEN(proc) bytes, including the terminating
	 * NUL if there's room for it.
	 */
	strncpy(STRING_PTR(proc), tproc, STRING_LEN(proc));
}
